#ifndef __C_DEBUGLAYER_H
#define __C_DEBUGLAYER_H

#include "Interfaces/cLayer.h"
#include "cDebugLayerParam.h"

class cRegisterList;

/*
 * cDebugLayer.h
 *
 * Debug layer --> Prints out any messages that pass through it.
 */
class cDebugLayer : public cLayer, public cDeliver
{

  public:

	/* -- Deliver Interface -- */
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);

	/* --  Layer Interface  -- */

	// Initialization/Cleanup
	bool Init(cLayer* layerBelow, cParam* param);
	bool Cleanup();

	// Sending of messages.
	bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType);

	// Timeslice
	bool Schedule() { return true; } //gInfo("Debug layer scheduled.", __LINE__, __FILE__); return true; }

	// Callback Registration/Unregisteration
	bool		RegisterDeliverCallback(cHandle* handle, cDeliver* callback);
	bool		UnregisterDeliverCallback(cHandle handle);
	bool		RegisterViewCallback(cHandle* handle, cView* callback);
	bool		UnregisterViewCallback(cHandle handle);
	bool		RegisterErrorCallback(cHandle* handle, cErrorCallback* callback);
	bool		UnregisterErrorCallback(cHandle handle);

	// Bonus!
	void		ReportStats(ostream &stream);

  private:
	cDebugLayerParam	mParam;
	cHandle				mLayerBelowHandle;
	cRegisterList*		mRegisterList;	
	char				mName[80];

	// STATISTICS
	unsigned int	mDroppedIn;
	unsigned int	mPassedIn;
	unsigned int	mDroppedOut;
	unsigned int	mPassedOut;
};

#endif
